<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Store\PaymentController;
use App\Http\Controllers\Api\ServerActionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/transaction/{id}/status', [PaymentController::class, 'checkStatus'])->name('store.api.status');


// Webhooks

Route::post('/stripe/webhook', [PaymentController::class, 'stripeWebhook'])->name('api.stripe.webhook')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);


Route::prefix('server')->middleware('server.auth')->group(function () {
    // Debug endpoint
    Route::get('/debug', [ServerActionController::class, 'debug']);
    
    // Get pending actions for server (called every 60 seconds by Gmod)
    Route::get('/actions', [ServerActionController::class, 'getPendingActions']);
    
    // Mark single action as completed
    Route::post('/actions/{actionId}/complete', [ServerActionController::class, 'markActionComplete']);
    
    // Mark multiple actions as completed
    Route::post('/actions/complete', [ServerActionController::class, 'markActionsComplete']);
    
    // Optional: Server heartbeat
    Route::post('/heartbeat', [ServerActionController::class, 'serverHeartbeat']);
    
    // Optional: Test API connection
    Route::get('/test', [ServerActionController::class, 'testConnection']);
    
    // Create test action for debugging
    Route::post('/test-action', [ServerActionController::class, 'createTestAction']);
});